<?php
include 'DatabaseConfig.php';

$con = mysqli_connect($HostName, $HostUser, $HostPass, $DatabaseName);

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get JSON data from the request body
    $data = json_decode(file_get_contents("php://input"));

    if ($data === null) {
        echo 'Invalid JSON data';
    } else {
        $ClientId = $data->ClientId;
        $CardNumber = $data->CardNumber;

        // Perform input validation here if needed
        // e.g., checking if $ClientId and $CardNumber are valid

        // Use prepared statements for security
        $Update_Query = "UPDATE ClientTable SET CardNumber = ? WHERE ClientId = ?";

        $stmt = mysqli_prepare($con, $Update_Query);

        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "si", $CardNumber, $ClientId);

            if (mysqli_stmt_execute($stmt)) {
                echo 'Updated Successfully';
            } else {
                echo 'Failed to Update';
            }

            mysqli_stmt_close($stmt);
        } else {
            echo 'Failed to prepare statement';
        }
    }
} else {
    echo 'Invalid request method';
}

mysqli_close($con);
?>
