<?php
// Include the database connection file
include 'db_connection.php';

// Check if the CardNumber parameter is provided
if (isset($_GET['CardNumber'])) {
    // Sanitize the input to prevent SQL injection
    $CardNumber = $conn->real_escape_string($_GET['CardNumber']);

    // Prepare the SQL query with a placeholder
    $sql = "SELECT ClientId, ClientName, ClientMobile1, CardNumber FROM ClientTable WHERE CardNumber = ?";
    
    // Prepare the statement
    $stmt = $conn->prepare($sql);

    // Bind the CardNumber parameter to the placeholder
    $stmt->bind_param("s", $CardNumber);

    // Execute the statement
    $stmt->execute();

    // Get the result
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result && $result->num_rows > 0) {
        // Fetch the result row
        $row = $result->fetch_assoc();

        // Get the data
        $ClientId = $row['ClientId'];
        $ClientName = $row['ClientName'];
        $ClientMobile1 = $row['ClientMobile1']; 
        $CardNumber = $row['CardNumber'];

        // Create an array for the JSON response
        $response = array(
            'status' => 'success',
            'ClientId' => $ClientId,
            'ClientName' => $ClientName,
            'ClientMobile1' => $ClientMobile1,
            'CardNumber' => $CardNumber
        );
    } else {
        // No rows were returned or an error occurred
        $response = array(
            'status' => 'error',
            'message' => 'No data found for the provided CardNumber.'
        );
    }
    
    // Close the statement
    $stmt->close();
} else {
    // CardNumber parameter is missing
    $response = array(
        'status' => 'error',
        'message' => 'CardNumber parameter is missing.'
    );
}

// Return the JSON response
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
$conn->close();
?>
