<?php

// Database credentials
 
$servername = "localhost";
$username = "shaadico_ntpaanduser";
$password = "NtP@@/\/pa$$555";
$dbname = "shaadico_ntpaandb";

// Create a connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// API endpoint to retrieve client data as JSON
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if a specific client ID is provided as a parameter in the URL
    if (isset($_GET['client_id'])) {
        $clientID = $_GET['client_id'];
        
        // Prepare the SQL statement with a WHERE condition to get data for a specific client
        $stmt = $conn->prepare("SELECT ClientId, ClientName, ClientMobile1, ClientMobile2, ClientAddress, ClientCity, ClientState, ClientGSTNO, ClientPanNo, ClientPinCode, ClientDOB, ClientNoofFamilyMember, ClientEmail, ClientLatitude, ClientLongitude, CardNumber, AcitveStatus,
                                  (SELECT SUM(Amount) FROM Transactions WHERE TransactionType = 'Credit' AND ClientId = C.ClientId) AS TotalCreditAmount,
                                  (SELECT SUM(Amount) FROM Transactions WHERE TransactionType = 'Debit' AND ClientId = C.ClientId) AS TotalDebitAmount,
                                  ((SELECT SUM(Amount) FROM Transactions WHERE TransactionType = 'Credit' AND ClientId = C.ClientId) - (SELECT SUM(Amount) FROM Transactions WHERE TransactionType = 'Debit' AND ClientId = C.ClientId)) AS Balance
                           FROM ClientTable AS C
                           WHERE ClientId = ?");

        // Bind the parameter
        $stmt->bind_param("i", $clientID);

        // Execute the statement
        $stmt->execute();

        // Bind the result
        $stmt->bind_result($clientId, $clientName, $clientMobile1, $clientMobile2, $clientAddress, $clientCity, $clientState, $clientGSTNO, $clientPanNo, $clientPinCode, $clientDOB, $clientNoofFamilyMember, $clientEmail, $ClientLatitude, $ClientLongitude, $CardNumber, $ActiveStatus, $totalCreditAmount, $totalDebitAmount, $balance);

        // Create an array to hold the client data
        $clientData = array();

        // Fetch the result
        $stmt->fetch();

        // Check if a client was found
        if ($clientId) {
            $clientData = array(
                "ClientId" => $clientId,
                "ClientName" => $clientName,
                "ClientMobile1" => $clientMobile1,
                "ClientMobile2" => $clientMobile2,
                "ClientAddress" => $clientAddress,
                "ClientCity" => $clientCity,
                "ClientState" => $clientState,
                "ClientGSTNO" => $clientGSTNO,
                "ClientPanNo" => $clientPanNo,
                "ClientPinCode" => $clientPinCode,
                "ClientDOB" => $clientDOB,
                "ClientNoofFamilyMember" => $clientNoofFamilyMember,
                "ClientEmail" => $clientEmail,
                "ClientLatitude" => $ClientLatitude,
                "ClientLongitude" => $ClientLongitude,
                "CardNumber" => $CardNumber,
                "ActiveStatus" => $ActiveStatus,
                "TotalCreditAmount" => $totalCreditAmount,
                "TotalDebitAmount" => $totalDebitAmount,
                "Balance" => $balance
            );
        }

        // Close the statement
        $stmt->close();

        // Return the JSON response
        header('Content-Type: application/json');
        echo json_encode($clientData);
    } else {
        // If no client ID is provided, you can return an error or handle it accordingly
        header('Content-Type: application/json');
        echo json_encode(array("error" => "No client ID provided"));
    }
}

// Close the connection
$conn->close();
?>
