<?php
 
require_once 'DbConnect.php';
 
$response = array();
 
if (isset($_GET['apicall'])) {
    switch ($_GET['apicall']) {
        case 'signup':
            if (isTheseParametersAvailable(array('username', 'email', 'password', 'gender'))) {
                $username = $_POST['username'];
                $email = $_POST['email'];
                $password = md5($_POST['password']);
                $gender = $_POST['gender'];
 
                $stmt = $conn->prepare("SELECT Userid FROM users WHERE username = ? OR email = ?");
                $stmt->bind_param("ss", $username, $email);
                $stmt->execute();
                $stmt->store_result();
 
                if ($stmt->num_rows > 0) {
                    $response['error'] = true;
                    $response['message'] = 'User already registered';
                    $stmt->close();
                } else {
                    $stmt = $conn->prepare("INSERT INTO users (username, email, password, gender) VALUES (?, ?, ?, ?)");
                    $stmt->bind_param("ssss", $username, $email, $password, $gender);
 
                    if ($stmt->execute()) {
                        $stmt = $conn->prepare("SELECT Userid, username, email, gender FROM users WHERE username = ?");
                        $stmt->bind_param("s", $username);
                        $stmt->execute();
                        $stmt->bind_result($userid, $username, $email, $gender);
                        $stmt->fetch();
 
                        $user = array(
                            'Userid' => $userid,
                            'username' => $username,
                            'email' => $email,
                            'gender' => $gender
                        );
 
                        $stmt->close();
 
                        $response['error'] = false;
                        $response['message'] = 'User registered successfully';
                        $response['user'] = $user;
                    }
                }
            } else {
                $response['error'] = true;
                $response['message'] = 'Required parameters are not available';
            }
 
            break;
 
        case 'login':
            if (isTheseParametersAvailable(array('username', 'password'))) {
                $username = $_POST['username'];
                $password = md5($_POST['password']);
 
                $stmt = $conn->prepare("SELECT Userid, username, bizidentifier, email, gender, allowReport, allowSendSms, allowOnlineBilling, FbMail, Fpp, FApky, FAppId, fUrl, UserStaus, LoginStatus, AllowedSoftware,FranchiseId FROM users WHERE username = ? AND password = ?");
                $stmt->bind_param("ss", $username, $password);
 
                $stmt->execute();
 
                $stmt->store_result();
 
                if ($stmt->num_rows > 0) {
                    $stmt->bind_result($userid, $username, $bizidentifier, $email, $gender, $allowReport, $allowSendSms, $allowOnlineBilling, $FbMail, $Fpp, $FApky, $FAppId, $fUrl, $UserStaus, $LoginStatus, $AllowedSoftware,$FranchiseId);
                    $stmt->fetch();
 
                    $user = array(
                        'Userid' => $userid,
                        'username' => $username,
                        'bizidentifier' => $bizidentifier,
                        'email' => $email,
                        'gender' => $gender,
                        'allowReport' => $allowReport,
                        'allowSendSms' => $allowSendSms,
                        'allowOnlineBilling' => $allowOnlineBilling,
                        'FbMail' => $FbMail,
                        'Fpp' => $Fpp,
                        'FApky' => $FApky,
                        'FAppId' => $FAppId,
                        'fUrl' => $fUrl,
                        'UserStaus' => $UserStaus,
                        'LoginStatus' => $LoginStatus,
                        'AllowedSoftware' => $AllowedSoftware,
                        'FranchiseId' => $FranchiseId
                    );
 
                    $response['error'] = false;
                    $response['message'] = 'Login successful';
                    $response['user'] = $user;
                } else {
                    $response['error'] = false;
                    $response['message'] = 'Invalid username or password';
                }
            } else {
                $response['error'] = true;
                $response['message'] = 'Required parameters are not available';
            }
 
            break;
 
        case 'getset':
            if (isTheseParametersAvailable(array('username'))) {
                $username = $_POST['username'];
 
                $stmt = $conn->prepare("SELECT Userid, username, bizidentifier, email, gender, allowReport, allowSendSms, allowOnlineBilling, FbMail, Fpp, FApky, FAppId, fUrl, UserStaus, LoginStatus, AllowedSoftware,FranchiseId FROM users WHERE username = ?");
                $stmt->bind_param("s", $username);
                $stmt->execute();
                $stmt->bind_result($userid, $username, $bizidentifier, $email, $gender, $allowReport, $allowSendSms, $allowOnlineBilling, $FbMail, $Fpp, $FApky, $FAppId, $fUrl, $UserStaus, $LoginStatus, $AllowedSoftware,$FranchiseId);
                $stmt->fetch();
 
                $user = array(
                    'Userid' => $userid,
                    'username' => $username,
                    'bizidentifier' => $bizidentifier,
                    'email' => $email,
                    'gender' => $gender,
                    'allowReport' => $allowReport,
                    'allowSendSms' => $allowSendSms,
                    'allowOnlineBilling' => $allowOnlineBilling,
                    'FbMail' => $FbMail,
                    'Fpp' => $Fpp,
                    'FApky' => $FApky,
                    'FAppId' => $FAppId,
                    'fUrl' => $fUrl,
                    'UserStaus' => $UserStaus,
                    'LoginStatus' => $LoginStatus,
                    'AllowedSoftware' => $AllowedSoftware,
                    'FranchiseId' => $FranchiseId
                );
                $response['error'] = false;
                $response['message'] = 'Welcome back';
                $response['user'] = $user;
            } else {
                $response['error'] = true;
                $response['message'] = 'Invalid username or password';
            }
 
            break;
 
        default:
            $response['error'] = true;
            $response['message'] = 'Invalid operation called';
    }
} else {
    $response['error'] = true;
    $response['message'] = 'Invalid API call';
}
 
echo json_encode($response);
 
function isTheseParametersAvailable($params) {
    foreach ($params as $param) {
        if (!isset($_POST[$param])) {
            return false;
        }
    }
    return true;
}
